@extends('layout')
@section('content')
    <!-- Book A Table Section -->
    <section id="book-a-table" class="book-a-table section">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>Book A Table</h2>
            <p><span>Reserve Your Night in</span> <span class="description-title">Style<br></span></p>
        </div><!-- End Section Title -->

        <div class="container">

            <div class="row g-0" data-aos="fade-up" data-aos-delay="100">

                <div class="col-lg-4 reservation-img" style="background-image: url({{ $setup?->booking_image_url }});"></div>

                <div class="col-lg-8 d-flex align-items-center reservation-form-bg" data-aos="fade-up" data-aos-delay="200">
                    <form action="{{ route('table-booking.store') }}" method="post" class="p-4">
                        @csrf
                        <div class="row gy-4">
                            <!-- First Name -->
                            <div class="col-lg-4 col-md-6">
                                <label for="first_name" class="form-label">First Name</label>
                                <input type="text" name="first_name" class="form-control" id="first_name"
                                    placeholder="First Name" required>
                            </div>

                            <!-- Last Name -->
                            <div class="col-lg-4 col-md-6">
                                <label for="last_name" class="form-label">Last Name</label>
                                <input type="text" name="last_name" class="form-control" id="last_name"
                                    placeholder="Last Name" required>
                            </div>

                            <!-- Phone -->
                            <div class="col-lg-4 col-md-6">
                                <label for="phone" class="form-label">Phone Number</label>
                                <input type="text" name="phone" class="form-control" id="phone"
                                    placeholder="Phone Number" required>
                            </div>

                            <!-- Email -->
                            <div class="col-lg-4 col-md-6">
                                <label for="email" class="form-label">Email Address</label>
                                <input type="email" name="email" class="form-control" id="email"
                                    placeholder="Email Address" required>
                            </div>

                            <!-- Date -->
                            <div class="col-lg-4 col-md-6">
                                <label for="date" class="form-label">Event Date</label>
                                <input type="date" name="date" class="form-control" id="date" required>
                            </div>

                            <!-- Approximate Budget -->
                            <div class="col-lg-4 col-md-6">
                                <label for="budget" class="form-label">Approximate Budget</label>
                                <input type="text" name="budget" class="form-control" id="budget"
                                    placeholder="e.g. $2000" required>
                            </div>

                            <!-- Party Size -->
                            <div class="col-lg-4 col-md-6">
                                <label for="party_size" class="form-label">Total Party Size</label>
                                <input type="number" name="party_size" class="form-control" id="party_size"
                                    placeholder="Total Number of People" required>
                            </div>

                            <!-- Number of Guys -->
                            <div class="col-lg-4 col-md-6">
                                <label for="guys" class="form-label">Number of Guys</label>
                                <input type="number" name="guys" class="form-control" id="guys"
                                    placeholder="Number of Guys" required>
                            </div>

                            <!-- Number of Girls -->
                            <div class="col-lg-4 col-md-6">
                                <label for="girls" class="form-label">Number of Girls</label>
                                <input type="number" name="girls" class="form-control" id="girls"
                                    placeholder="Number of Girls" required>
                            </div>
                        </div>


                        <div class="form-group mt-3">
                            <textarea class="form-control" name="message" rows="5" placeholder="Message"></textarea>
                        </div>

                        <div class="text-center mt-3">



                            <button type="submit" class="btn btn-danger py-2 px-4">Book a Table</button>
                        </div>
                    </form>
                </div><!-- End Reservation Form -->

            </div>

        </div>

    </section><!-- /Book A Table Section -->


    <!-- Book A Table Section -->
    <section id="book-a-table" class="book-a-table section">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>Book A Table</h2>
            <p><span>Model Sign-Up: </span> <span class="description-title">Join the Guestlist Elite<br></span></p>
        </div><!-- End Section Title -->

        <div class="container">

            <div class="row g-0" data-aos="fade-up" data-aos-delay="100">


                <div class="col-lg-8 d-flex p-4 align-items-center reservation-form-bg" data-aos="fade-up"
                    data-aos-delay="200">
                    <form action="{{ route('registration.store') }}" method="post">
                        @csrf
                        <div class="row gy-4">
                            <!-- First Name -->
                            <div class="col-lg-4 col-md-6">
                                <label for="first_name" class="form-label">First Name</label>
                                <input type="text" name="first_name" class="form-control" id="first_name"
                                    placeholder="First Name" required>
                            </div>

                            <!-- Last Name -->
                            <div class="col-lg-4 col-md-6">
                                <label for="last_name" class="form-label">Last Name</label>
                                <input type="text" name="last_name" class="form-control" id="last_name"
                                    placeholder="Last Name" required>
                            </div>

                            <!-- Phone -->
                            <div class="col-lg-4 col-md-6">
                                <label for="phone" class="form-label">Phone Number</label>
                                <input type="text" name="phone" class="form-control" id="phone"
                                    placeholder="Phone Number" required>
                            </div>

                            <!-- Email -->
                            <div class="col-lg-4 col-md-6">
                                <label for="email" class="form-label">Email Address</label>
                                <input type="email" name="email" class="form-control" id="email"
                                    placeholder="Email Address" required>
                            </div>

                            <!-- Birthdate -->
                            <div class="col-lg-4 col-md-6">
                                <label for="birthdate" class="form-label">Birthdate</label>
                                <input type="date" name="birthdate" class="form-control" id="birthdate" required>
                            </div>

                            <!-- Height -->
                            <div class="col-lg-4 col-md-6">
                                <label for="height" class="form-label">Height (in cm or ft)</label>
                                <input type="text" name="height" class="form-control" id="height"
                                    placeholder="e.g. 175 cm or 5'9" required>
                            </div>

                            <!-- Instagram -->
                            <div class="col-lg-4 col-md-6">
                                <label for="instagram" class="form-label">Instagram Handle</label>
                                <input type="text" name="instagram" class="form-control" id="instagram"
                                    placeholder="@yourhandle" required>
                            </div>

                            <!-- Agency -->
                            <div class="col-lg-4 col-md-6">
                                <label for="agency" class="form-label">Agency (if any)</label>
                                <input type="text" name="agency" class="form-control" id="agency"
                                    placeholder="Agency Name or 'Freelance'">
                            </div>

                            <!-- Dates in New York -->
                            <div class="col-lg-4 col-md-6">
                                <label for="dates_in_ny" class="form-label">Dates in New York</label>
                                <input type="text" name="dates_in_ny" class="form-control" id="dates_in_ny"
                                    placeholder="e.g. May 5–12 or All Summer" required>
                            </div>
                        </div>




                        <div class="text-center mt-3">

                            <button type="submit" class="btn btn-danger py-2 px-4">Sign Up</button>
                        </div>
                    </form>
                </div><!-- End Reservation Form -->
                <div class="col-lg-4 reservation-img" style="background-image: url({{ $setup?->bottle_image_url }});">
                </div>

            </div>

        </div>

    </section><!-- /Book A Table Section -->

 <div class="container">
    <div class="row">
        @foreach ($blogs as $d)
            <div class="col-12 col-md-4 mb-4">
                <a href="{{ route('blog.show',$d->id) }}" class="card bg-light h-100">
                    <div class="card-header"></div>
                    <div class="card-body">
                        <h5 class="card-title">{{ $d->title }}</h5>
                        <p class="card-text">
                            {{ Str::limit(strip_tags($d->content), 300, ' ...') }}

                        </p>
                    </div>
                </a>
            </div>
        @endforeach
    </div>
</div>

@endsection
